package gov.va.vamf.scheduling.direct.domain

import spock.lang.Specification
import spock.lang.Unroll

class CustomRequestSettingSpec extends Specification {
    @Unroll
    def 'CustomRequestSetting is #status if the setting field is #supported'() {
        when:
        def customRequestSetting = new CustomRequestSetting('id-1', '', supported, null)

        then:
        customRequestSetting.isEnabled() == supported

        where:
        supported << [true, false]
        status = supported ? 'enabled' : 'disabled'
    }
}
